libname wmiri 'J:\Dropbox\Projects\Walmart\CTSupermarkets\tasks\IRI data';

%let NUMWM = 3260; *Number of WM Supercenters;
%let MAXWEEK = 573; *Max weekid (2001-2011);
%let MINWEEK = -2002; *Oldest Supercenter;
%let NUMMAX15 = 24; *Max number of Supercenters within 15 miles;
*Week of Jan. 1, 2001 is weekid == 1;
PROC IMPORT OUT= WORK.wm
            DATAFILE= "J:\Dropbox\Projects\Walmart\CTSupermarkets\WMopeningdates_update_latlon.csv" 
            DBMS=CSV REPLACE;
     GETNAMES=YES;
     DATAROW=2; 
RUN;
PROC IMPORT OUT= WORK.iri_loc 
            DATAFILE= "C:\Users\John\Dropbox\CTSupermarkets\tasks\IRI data\delivery store fips zip zip_centroid lon lat Yr1_11.csv" 
            DBMS=CSV REPLACE;
     GETNAMES=YES;
     DATAROW=2; 
RUN;

data work.loc (keep = iri_key lon lat);
	set work.iri_loc;
proc sort data = work.loc;
	by iri_key;
run;
proc sql;
create table work.loc2 as
select distinct iri_key, mean(lon) as lon, mean(lat) as lat
from work.loc
group by iri_key
order by iri_key;
quit;
data work.stores_loc;
	set work.loc2;
	by iri_key;

	merge = 1;
run;

data work.entry (keep = wmid city lat lon day weekid week month year);
	set work.wm;
	if StoreType="Supercenter";
	lat = latitude;
	lon = longitude;
	month = month(OpenDate);
	year = year(OpenDate);
	day = day(OpenDate);
	week = week(OpenDate);
	weekid = (year - 2001)*52 + week;
	city = BuildingCity;
	wmid = StoreNbr;
run;
data work.entry;
	set work.entry;
	num = _N_;
run;
proc transpose data = work.entry out=work.lat prefix=lat;
	id num;
	var lat;
proc transpose data = work.entry out=work.lon prefix=lon;
	id num;
	var lon;
data work.wm_lon_lat;
	merge work.lon work.lat;
data work.wm_lon_lat (drop=_name_);		
	set work.wm_lon_lat;
	merge=1;
run;
data work.stores_loc_wm (drop=merge lat lon);
	merge stores_loc work.wm_lon_lat;
	by merge;
	lat_own = lat;
	lon_own = lon;
run;
data work.store_loc_dis (keep = iri_key lat_own lon_own d1-d&NUMWM); 
	set work.stores_loc_wm;
	pi = 3.141592653589793238;
	array lat {*} lat1-lat&NUMWM;
	array lon {*} lon1-lon&NUMWM;
	array dlon {*} dlon1-dlon&NUMWM;
	array dlat {*} dlat1-dlat&NUMWM;
	array a {*} a1-a&NUMWM;
	array d {*} d1-d&NUMWM;
	do i = 1 to &NUMWM; *688 total WM Supercenter entries;
		dlon{i} = (lon{i} - lon_own)*pi/180;
		dlat{i} = (lat{i} - lat_own)*pi/180;
		a{i} = SIN(dlat{i}/2)**2 + COS(lat{i}*pi/180)*COS(lat_own*pi/180)*SIN(dlon{i}/2)**2;
		d{i} = 2*3961*ARSIN(SQRT(a{i})); 
	end;
run;

data work.rad_15 (keep = iri_key merge wm1-wm&NUMWM);
	set work.store_loc_dis;
	merge = 1;
	array d {*} d1-d&NUMWM;
	array wm {*} wm1-wm&NUMWM;
	do i = 1 to &NUMWM;
	if d{i} < 15 then wm{i} = 1;
	else wm{i} = 0;
	end;
run;

data work.wm_temp (keep = weekid num);
	set work.entry;
proc transpose data = work.wm_temp out = wm_transpose prefix=week;
	id num;
	var weekid;
data work.wm_transpose;
	set work.wm_transpose;
	merge = 1;
run;
data work.wm_15_week (keep = iri_key wm1-wm&NUMWM);
	merge work.rad_15 work.wm_transpose;	
	by merge;
	array week {*} week1-week&NUMWM;
	array wm {*} wm1-wm&NUMWM;
	do i = 1 to &NUMWM;
	wm{i} = wm{i} * week{i};
	end;
run;

data work.temp;
	set work.wm_15_week;

	array wm {*} wm1-wm&NUMWM;

	do i = 1 to &NUMWM;
	if wm{i} = 0 then wm{i} = .;
	end;

data work.temp2 (drop = wm1-wm&NUMWM i j);
	set work.temp;

	array wm {*} wm1-wm&NUMWM;
	array WM15_ {*} WM15_1-WM15_&NUMMAX15;

	by iri_key;
	do j = 1 to &NUMMAX15;
	do i = 1 to &NUMWM;
	if wm{i} = smallest(j, of wm1-wm&NUMWM)
	then WM15_{j} = i;
	end;
	end;

run;
data work.temp3 (drop = wm1-wm&NUMWM i j);
	set work.temp;

	array wm {*} wm1-wm&NUMWM;
	array WM15_week_ {*} WM15_week_1-WM15_week_&NUMMAX15;

	by iri_key;
	do j = 1 to &NUMMAX15;
	do i = 1 to &NUMWM;
	if wm{i} = smallest(j, of wm1-wm&NUMWM)
	then WM15_week_{j} = wm{i};
	end;
	end;

run;

data work.stores_panel_15 (keep = iri_key WM15_week_1-WM15_week_&NUMMAX15 weekid);
	set work.temp3;
	by iri_key;
	do i = 1 to &MAXWEEK; *No WM entries after 573 weeks;
		weekid = i;
		output;
	end;
run;
*Panel of WM entries;
data work.stores_wm_15 (keep = iri_key weekid wm1-wm&NUMMAX15);
	set work.stores_panel_15;
	by iri_key weekid;
	array WM15_week_ {*} WM15_week_1-WM15_week_&NUMMAX15;
	array wm {*} wm1-wm&NUMMAX15;

	do i = 1 to &NUMMAX15;
	if WM15_week_{i} ne . and WM15_week_{i} <= weekid then wm{i} = 1; *Assumes no entries last week of 2000;
	else wm{i} = 0;
	end;

run;
*IRI store-WM matches with WM ID;
data work.iri_wm_match_15 (keep = iri_key wm_id1-wm_id&NUMMAX15);
	merge work.temp2 work.temp3;
	by iri_key;

	array WM15_week_ {*} WM15_week_1-WM15_week_&NUMMAX15;
	array WM15_ {*} WM15_1-WM15_&NUMMAX15;
	array wm_id {*} wm_id1-wm_id&NUMMAX15;

	do i = 1 to &NUMMAX15;
	wm_id{i} = WM15_{i} * (WM15_week_{i} ne .);
	end;

run;

data work.iri_wm_loc;
	merge work.iri_wm_match_15 work.stores_loc_wm;
	by iri_key;
run;
*IRI store-WM matches with location;
data work.iri_wm_loc2 (keep = iri_key lat_own lon_own wm_lat1-wm_lat&NUMMAX15 wm_lon1-wm_lon&NUMMAX15);
	set work.iri_wm_loc;

	array wm_id {*} wm_id1-wm_id&NUMMAX15;
	array wm_lat {*} wm_lat1-wm_lat&NUMMAX15;
	array wm_lon {*} wm_lon1-wm_lon&NUMMAX15;
	array lat {*} lat1-lat&NUMWM;
	array lon {*} lon1-lon&NUMWM;

	by iri_key;
	do j = 1 to &NUMMAX15;
	if wm_id{j} ne 0
	then do; wm_lat{j} = lat{wm_id{j}};
			wm_lon{j} = lon{wm_id{j}}; end;
	if wm_id{j} = 0
	then do; wm_lat{j} = .;
			wm_lon{j} = .; end;
	end;
	
run;

*load stores;

proc sql;
create table work.stores as
select unique iri_key
from work.revenue
order by iri_key;
quit;
*Restrict to stores with sales data;
data work.iri_wm_loc_stores;
	merge work.stores (in=in1) work.iri_wm_loc2 (in=in2);
	by iri_key;
	if in1 and in2;

run;

